----------------
title : C++ 레퍼런스 - ios_base::sync_with_stdio 함수
cat_title : ios_base::sync_with_stdio
ref_title : ios_base::sync_with_stdio, sync_with_stdio
publish_date : 2019-04-26
path : /C++ Reference/iostream
--------------

##@ cpp-ref-start

#@ ios_base::sync_with_stdio

```cpp-formatted
static bool sync_with_stdio(bool sync = true);
```

C++ 표준 스트림들이 C 표준 스트림들과 각각의 입출력 연산 후에 동기화 할지 여부를 설정한다.

표준 C++ 스트림들은 다음과 같다. `std::cin`, `std::cout`, `std::cerr`, `std::clog`, `std::wcin`, `std::wcout`, `std::wcerr`, `std::wclog`

표준 C 스트림들은 다음과 같다. `stdin`, `stdout`, `stderr`

*어떤 C++ 표준 스트림 `str` 이 C 스트림 `f` 와 동기화 되어있다*라는 의미는 아래의 함수들이 동일한 효과를 낸다는 의미 이다.

1. `std::fputc(f, c)` 와 `str.rdbuf()->sputc(c)`
2. `std::fgetc(f)` 와 `str.rdbuf()->sbumpc()`
3. `std::ungetc(c, f)` 와 `str.rdbuf()->sputbackc(c)`

이 말은 즉슨, 동기화된 C++ 스트림들이 자신들의 버퍼를 사용하지 않고 (unbuffered), C++ 스트림의 입출력 연산들이 이에 대응되는 C 스트림 버퍼를 직접 사용한다라는 의미와 같다. 따라서, 스트림들을 동기화 하였다면, C++ 입출력 연산과 C 입출력 연산들을 혼합해서 사용할 수 있게 된다.

하지만 동기화를 껐을 경우 C 입출력 연산과 C++ 입출력 연산을 같이 사용한다면, 그 입출력 순서들이 보장되지 않는다. (아래 실행 예제 참조) 

추가적으로 동기화된 C++ 스트림들은 쓰레드 안정성이 보장된다. 쉽게 말해, 여러 쓰레드에서 각각 출력연산을 수행할 수 있지만, 경쟁 상태 (race condition)는 발생하지 않는다.

만일 동기화를 설정하지 않았더라면, 표준 C++ 스트림들은 각각의 입출력 연산에 대해 버퍼를 사용할 수 있는데, **이 경우 입출력 연산 속도로를 크게 향상 시킬 수 있다**.

기본적으로는 8 개의 모든 C++ 표준 스트림들은 각각의 대응되는 C 스트림과 동기화 되어 있다.


### 인자들

* `sync` : 새로운 동기화 상태

### 리턴값

함수 호출하기 전 이전의 동기화 상태

### 실행 예제

```cpp-formatted
#include <cstdio>
#include <iostream>

int main() {
  std::ios::sync_with_stdio(false);
  std::cout << "a\n";

  // 동기화 되어 있지 않기에 b 가 먼저 혹은 나중에 출력된다.
  std::printf("b\n");
  std::cout << "c\n";
}
```

```exec
b
a
c
```

### 참고 자료

* `cout`, `wcout` : C 표준 출력 스트림 `stdout` 에 출력한다.
* `cerr`, `wcerr` : C 표준 오류 스트림 `stderr` 에 출력한다. 이 때 버퍼를 사용하지 않는다.
* `clog`, `wclog` : C 표준 오류 스트림 `stderr` 에 출력한다.